<?php
// *********************************************************************************************************************************
//
//	utils.inc.php
//
// *********************************************************************************************************************************

defined('kPHP_Platform') or die('Access Not Allowed');

// The Twilio library for sending text messages. Use whatever provider works best for you.
require_once('Twilio/Twilio.php');

// *********************************************************************************************************************************
//
//	SignIn
//
// Verify the user credentials
//
// *********************************************************************************************************************************
function SignIn($userName, $password)
{
	$response = array('result' => 0, 'message' => '');

	// Find the User record, connecting to FileMaker using the username/password entered in the sign in form.
	$fm = new FileMaker(FM_DATABASE, FM_HOST, $userName, $password);
	$findCommand = $fm->newFindCommand(FM_USER_LAYOUT);
	$findCommand->addFindCriterion(FM_USER_ACCOUNT_FIELD, FILEMAKER_FIND_FIELDMATCH . $userName);
	$result = $findCommand->execute();

	if (! FileMaker::IsError($result)) {
		$record = $result->getFirstRecord();
		sessionSet('userFullName', $record->getField(FM_USER_FULLNAME_FIELD));

		// Is the user required to be challenged with a verification code?
		// This is probably a very BAD idea to have in a production environment, but this is a demo, right? :)
		if ($record->getField(FM_USER_REQUIRE_2_FACTOR_FIELD)) {
			if ($record->getField(FM_USER_Mobile_Number_FIELD) != '') {
				sessionSet('userMobileLast4', substr($record->getField(FM_USER_Mobile_Number_FIELD), -4));

				$response = SendVerificationCode($record->getField(FM_USER_Mobile_Number_FIELD));

				if ($response['result'] == 0) {
					sessionSet('verificationCode', $response['verificationCode']);
					sessionSet('verificationCodeExpirationTime', $response['verificationCodeExpirationTime']);
					RedirectClient('verify.php');
				}
				else {
					$response['message'] = '<h4 style="color: red;">Sorry dude, we couldn\'t send your a verification code.</h4>';
				}
			}
			else {
				$response['message'] = '<h4 style="color: red;">Sorry dude, your mobile phone number is not in our system.</h4>';
				}
		}
		else {
			sessionSet('loggedIn', 1);														// No verification required.
			RedirectClient('index.php');													// Off we go to our home page.
		}
	}
	else {
		$response['result'] = $result->getCode();
		if ($response['result'] == 22) {													// Bad credentials?
			$response['message'] = '<h4 style="color: red;">Sorry dude, that is not the correct user name and/or password.</h4>';
		}
		else if ($response['result'] == 401) {												// No User record in FileMaker?
			$response['message'] = '<h4 style="color: red;">Sorry dude, you don\'t have an account in FileMaker.</h4>';
		}
		else {
			$response['message'] = '<h4 style="color: red;">'. $result->getMessage() .'</h4>';
		}
	}

	return $response;
}


// *********************************************************************************************************************************
//
//	VerifyCode
//
// Verify that the verification code sent to the user matches what they typed in.
//
// *********************************************************************************************************************************
function VerifyCode($code)
{
	$response = array('result' => 0, 'message' => '');

	if (($code == sessionGet('verificationCode')) &&											// Does the code match?
	    (sessionGet('verificationCodeExpirationTime') > time())) {							// Make sure the code hasn't exipired
		sessionSet('loggedIn', 1);
		sessionSet('userMobileLast4');
		sessionSet('verificationCode');
		sessionSet('verificationCodeExpirationTime');
		RedirectClient('index.php');																	// Off we go to our home page.
	}
	else {
		$response['message'] = '<h4 style="color: red;">Sorry dude, that is not the correct verification code.</h4>';
	}

	return $response;
}


// *********************************************************************************************************************************
//
//	SendVerificationCode
//
// Send a text message with a 'randomly' generated verfication code.
//
// *********************************************************************************************************************************
function SendVerificationCode($phoneNumber)
{
	define('EXPIRETIMEOUT',	15);												// Code expires in 15 minutes

	// For our demo, let's generate a simple 6-digit 'random' number using PHP's mt_rand().
	// There are a number of libraries available that can create a more 'unique' code which you SHOULD use.
	$code = mt_rand(100000, 999999);

	$message = 'Your sign in verfication code is: '. $code .' It will expire in '. EXPIRETIMEOUT .' minutes.';

	$response = SendTextMessage($phoneNumber, $message);

	if ($response['result'] == 0) {
		$response['verificationCode'] = $code;
		$response['verificationCodeExpirationTime'] = time() + (EXPIRETIMEOUT * 60);
	}

	return $response;
}

// *********************************************************************************************************************************
//
//	SendTextMessage
//
// Send a text message. This implmentation uses Twilio as our text messaging provider.
//
// *********************************************************************************************************************************
function SendTextMessage($phoneNumber, $message)
{
	define('ACCOUNT_PHONE_NUMBER',	'YOUR-ACCOUNT-PHONE-NUMBER-HERE');
	define('ACCOUNT_SID',				'YOUR-ACCOUNT-SID-HERE');
	define('AUTH_TOKEN',					'YOUR-AUTH-TOKEN-HERE');

	$response = array('result' => 0, 'message' => '');

	$client = new Services_Twilio(ACCOUNT_SID, AUTH_TOKEN);
	try {
		$message = $client->account->messages->create(array('From' => ACCOUNT_PHONE_NUMBER, 'To' => $phoneNumber, 'Body' => $message));
	}
	catch (Services_Twilio_RestException $e) {
		$response['result'] = $e->getStatus();
		$response['message'] = $e->getInfo();
	}
	catch (Exception $e) {
		$response['message'] = $e->getMessage();
		$response['result'] = ($e->getCode() != 0) ? $e->getCode() : '-1';
	}

	return $response;
}

// *********************************************************************************************************************************
//
//	RedirectClient
//
// Redirect the client to a new web page. Always do an exit to make sure the script stops immediately.
//
// *********************************************************************************************************************************
function RedirectClient($location)
{
	header('Location: '. $location);
	exit;
}

?>
