<?php
// *********************************************************************************************************************************
//
//	signin.php
//
// *********************************************************************************************************************************

require_once('_php/startup.inc.php');

// If we're signed in, don't prompt again for the username & password!
if (sessionGet('loggedIn')) {
	RedirectClient('index.php');
}

$signInResponse = array('result' => 0, 'message' => '');

if ((cgiPost('username') != '') && (cgiPost('password') != '')) {						// Someone enter a username & password?
	$signInResponse = SignIn(cgiPost('username'), cgiPost('password'));
}

// Clear these session variables any time we present the sign in form.
sessionSet('loggedIn', 0);
sessionSet('userFullName');
sessionSet('userMobileLast4');

?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
		<title>Sign In</title>
		<link href="css/normalize.css" rel="stylesheet" />
		<link href="css/styles.css" rel="stylesheet" />
	</head>

	<body>

		<br>
		<b>Please sign in.</b>
		<form name="login" method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>">

			<?php if ($signInResponse['message'] != '') { echo $signInResponse['message']; } ?>

			User Name:<br>
			<input type="text" id="username" name="username" placeholder="User Name" required autofocus /><br>
			<br>

			Password<br>
			<input type="password" id="password" name="password" placeholder="Password" required /><br>
			<br>

			<input type="submit" value="Login" />
		</form>

		<br>
		<br>
		<br>

		<?php sessionPrintLog(); ?>
	</body>
</html>
