<?php
// *********************************************************************************************************************************
//
//	verify.php
//
// *********************************************************************************************************************************

require_once('_php/startup.inc.php');

// Put this check at the top of every file that requires the user to be signed in.
if (! sessionGet('loggedIn') && (sessionGet('verificationCode') == '')) {
	RedirectClient('signin.php');
}

$verifyResponse = array('result' => 0, 'message' => '');

if (cgiPost('code') != '') {										// Have verification code?
	$verifyResponse = VerifyCode(cgiPost('code'));
}

?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
		<title>Verification Code</title>
		<link href="css/normalize.css" rel="stylesheet" />
		<link href="css/styles.css" rel="stylesheet" />
	</head>

	<body>

		<br>
		<b><?php echo sessionGet('userFullName'); ?>, please enter the verification code sent to the phone number ending in <?php echo sessionGet('userMobileLast4'); ?>.</b>
		<form name="code" method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>">

			<?php if ($verifyResponse['message'] != '') { echo $verifyResponse['message']; } ?>

			<br>
			Verification Code<br>
			<input type="text" id="code" name="code" placeholder="Verification Code" required autofocus /><br>
			<br>

			<input type="submit" value="Verify" />
		</form>

		<br>
		<br>
		<br>

		<?php sessionPrintLog(); ?>
	</body>
</html>
