<?php
// *********************************************************************************************************************************
//
//	session.inc.php
//
// *********************************************************************************************************************************

defined('kPHP_Platform') or die('Access Not Allowed');

// *********************************************************************************************************************************
function sessionGet($key, $defaultValue = '')
{
	if (array_key_exists($key, $_SESSION) && ! is_numeric($key)) {
		return $_SESSION[$key];
	}
	else {
		return $defaultValue;
	}
}

// *********************************************************************************************************************************
function sessionSet($key, $value = '')
{
	if (! is_numeric($key)) {
		$_SESSION[$key] = $value;
	}

	return;
}



// *********************************************************************************************************************************
function sessionLog($message)
{
	sessionSet('z_DEBUG_LOG', sessionGet('z_DEBUG_LOG') .'<br>'. strftime('%H:%M:%S'). ' '. $message);
	return;
}

// *********************************************************************************************************************************
// Call this just before the end of your body tag to dump out the log
//
function sessionPrintLog()
{
	$logMessages = sessionGet('z_DEBUG_LOG');

	if ($logMessages != '') {
		echo '<div id="debugLogMessages" style="margin-top: 10px; padding-bottom: 10px; padding-left: 5px; padding-right: 5px; white-space: nowrap; font-family: monospace; font-weight: normal; font-size: 11px; line-height: 13px; border: 1px solid gray; background-color: #dddddd; text-align: left;">'.
					$logMessages .
				'</div>';

		sessionSet('z_DEBUG_LOG', '');
	}

	return;
}

?>
