<?php
// *********************************************************************************************************************************
//
//	utils.inc.php
//
// *********************************************************************************************************************************

defined('kPHP_Platform') or die('Access Not Allowed');

// *********************************************************************************************************************************
//
//	GetDownloadInfo
//
// *********************************************************************************************************************************
function GetDownloadInfo()
{
	$downloadInfo = array();

	$fm = new FileMaker(FM_DATABASE, FM_HOST, FM_USERNAME, FM_PASSWORD);
	$findCommand = $fm->newFindAllCommand(FM_FILE_LAYOUT);
	$result = $findCommand->execute();

	if (! FileMaker::IsError($result)) {
		$records = $result->getRecords();
		foreach ($records as $record) {
			$downloadInfo[] = ProcessOneFile($fm, $record);
		}
	}
	else {
		sessionLog($result->getCode() .' '. $result->getMessage());
	}

	return $downloadInfo;
}


// *********************************************************************************************************************************
//
//	GetOneFile
//
// *********************************************************************************************************************************
function GetOneFile($fileID)
{
	$downloadInfo = array();

	$fm = new FileMaker(FM_DATABASE, FM_HOST, FM_USERNAME, FM_PASSWORD);
	$findCommand = $fm->newFindCommand(FM_FILE_LAYOUT);
	$findCommand->addFindCriterion(FM_File_ID_FIELD, FILEMAKER_FIND_FIELDMATCH . $fileID);
	$result = $findCommand->execute();

	if (! FileMaker::IsError($result)) {
		$record = $result->getFirstRecord();
		$downloadInfo[] = ProcessOneFile($fm, $record);
	}
	else {
		sessionLog($result->getCode() .' '. $result->getMessage());
	}

	return $downloadInfo;
}


// *********************************************************************************************************************************
//
//	ProcessOneFile
//
// *********************************************************************************************************************************
function ProcessOneFile($fm, $record)
{
	$info = array();
	$info[FM_File_ID_FIELD] = $record->getField(FM_File_ID_FIELD);
	$info[FM_FILE_VERSION_FIELD] = $record->getField(FM_FILE_VERSION_FIELD);
	$info[FM_FILE_NAME_FIELD] = $record->getField(FM_FILE_NAME_FIELD);
	$info[FM_FILE_DESCRIPTION_FIELD] = $record->getField(FM_FILE_DESCRIPTION_FIELD);

	$saveFile = false;
	$path = DOWNLOADS_CACHE_PATH . $info[FM_File_ID_FIELD] . DIRECTORY_SEPARATOR;

	// See if the cache for this file is empty or there's a newer version in FileMaker.
	if (! file_exists($path .'data')) {
		mkdir($path);
		$saveFile = true;
	}
	else {
		$fileData = unserialize(file_get_contents($path .'data'));
		if ($fileData[FM_FILE_VERSION_FIELD] != $info[FM_FILE_VERSION_FIELD]) {
			unlink($path . $fileData[FM_FILE_NAME_FIELD]);
			$saveFile = true;
		}
	}

	if ($saveFile) {
		sessionLog('Grabbing '. $info[FM_File_ID_FIELD] .DIRECTORY_SEPARATOR. $info[FM_FILE_NAME_FIELD]);
		$fileData = serialize(array(FM_FILE_VERSION_FIELD => $info[FM_FILE_VERSION_FIELD], FM_FILE_NAME_FIELD => $info[FM_FILE_NAME_FIELD]));
		file_put_contents($path . 'data', $fileData);
		file_put_contents($path . $info[FM_FILE_NAME_FIELD], $fm->getContainerData($record->getField(FM_FILE_FILE_FIELD)));
	}

	// Change this to be the brower's download URL
	$info[FM_FILE_FILE_FIELD] = 'cache'. DIRECTORY_SEPARATOR .'downloads'. DIRECTORY_SEPARATOR . $info[FM_File_ID_FIELD] . DIRECTORY_SEPARATOR . $info[FM_FILE_NAME_FIELD];

	return $info;
}

?>
