<!DOCTYPE html>
<html>

   <head>
      <meta charset="utf-8" />
      <title>fmPDA for FX.php</title>
      <link href="css/normalize.css" rel="stylesheet" />
      <link href="css/styles.css" rel="stylesheet" />
      <link href="css/fontawesome-all.min.css" rel="stylesheet" />
      <link href="css/prism.css" rel="stylesheet" />
      <link href="js/bootstrap/css/bootstrap.css" rel="stylesheet" />
      <script src="js/prism.js"></script>
      <script src="js/jquery-3.3.1.js"></script>
      <script src="js/bootstrap/js/bootstrap.min.js"></script>
      <script src="js/main.js"></script>
   </head>

   <body>

      <!-- Always on top: Position Fixed-->
      <header>
         fmPDA <span class="fmPDA-heart"><i class="fas fa-heart"></i></span> for FX.php
      </header>


      <!-- Fixed size after header-->
      <div class="content">

         <!-- Always on top. Fixed position, fixed width, relative to content width-->
         <div class="navigation-left">

            <br>
            <a href="#fxfmpda-home">Home</a>
            <br>

            <div class="navigation-header2"><i class="fas fa-info-circle"></i> Metadata</div>

            <a href="#apiListDatabases"><span class="indent-1">List Databases</span></a>
            <a href="#apiListLayouts"><span class="indent-1">List Layouts</span></a>
            <a href="#apiListScripts"><span class="indent-1">List Scripts</span></a>
            <a href="#apiViewLayoutObjects"><span class="indent-1">View Layout Objects</span></a>
            <br>

            <div class="navigation-header2"><i class="fas fa-search fa-fw"></i> Find</div>
            <a href="#apiFindAll"><span class="indent-1">Find All Records</span></a>
            <a href="#apiFindAny"><span class="indent-1">Find Any Record</span></a>
            <a href="#apiFindSimple"><span class="indent-1">Find Records (Simple)</span></a>
            <a href="#apiFindCompound"><span class="indent-1">Find Records (Compound)</span></a>
            <br>

            <div class="navigation-header2"><i class="fas fa-edit fa-fw"></i> Editing</div>
            <a href="#apiAddRecord"><span class="indent-1">Add Record</span></a>
            <a href="#apiEditRecord"><span class="indent-1">Edit Record</span></a>
            <a href="#apiDeleteRecord"><span class="indent-1">Delete Record</span></a>
            <a href="#apiDuplicateRecord"><span class="indent-1">Duplicate Record</span></a>
            <br>

         </div>



          <!-- Scrollable div with main content -->
         <div class="main">

            <div id="fxfmpda-home">
               <div class="main-header">
                  fmPDA (<u>F</u>ileMaker <u>P</u>HP <u>D</u>ata <u>A</u>PI) for FX.php<br>
               </div>

               <h4>What is fmPDA <span class="fmPDA-heart"><i class="fas fa-heart"></i></span> for FX.php?</h4>
               <p>fmPDA for FX.php is a data source class for FX.php enabling your existing FX code to use the Data API in place of the XML interface. Only the call to the FX constructor needs to change in your code.</p>
               FileMaker Server 18 or later is required to support all features. For FileMaker 17, these will not work:<br>
               <ul>
                  <li>List Databases</li>
                  <li>List Layouts</li>
                  <li>List Scripts</li>
                  <li>View Layout Objects</li>
                  <li>Duplicate Record</li>
               </ul>
               <br>



               <h5>Installation</h5>
               <ul>
                  <li>
                     Copy the <code>RetrieveFXDataAPI.class</code> file and <code>RetrieveFXDataAPI</code> folder to your <code>FX/lib/datasource_classes/</code> directory.<br>
                  </li>
                  <li>
                     In the <code>FX::ExecuteQuery()</code> method, add the following to the <code>switch</code> statement:
                     <pre><code class="language-php">
                     case 'dapi':
                         require_once('lib/datasource_classes/RetrieveFXDataAPI.class.php');
                         $datasourceClassName = 'RetrieveFXDataAPI';
                         $datasourceDescription = 'FileMaker Data API';
                         break;
                     </code></pre>
                  </li>
               </ul>
               <br>


               <h5>Changes to your code</h5>
               You'll need to modify all of your calls to the FX constructor to pass <code>'dapi'</code> in place of the <code>'FMPro7'</code> data type. You will also need to make sure you're using <code>https:</code> and port <code>443</code> as the Data API requires these. In the example below, replace <code>127.0.0.1</code> with your actual host.<br>
               <br>
               <strong>Warning:</strong> Due to the way the FX constructor was written, you must prefix your host with <code>https://</code> to the first parameter (<code>$dataServer</code>). Passing <code>https</code> in the last parameter (<code>$dataURLType</code>) will not work.<br>
               <br>

               Old<br>
               <pre><code class="language-php">$fx = new FX('127.0.0.1', '80', 'FMPro7', 'http');</code></pre>

               New:<br>
               <pre><code class="language-php">$fx = new FX('https://127.0.0.1', '443', 'dapi', '');</code></pre>
               <br>
               <br>
            </div>

            <div id="apiListDatabases" class="api-object">
               <div class="api-header">
                  FX::FMDBNames()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMDBNames()

                        Retrieve a list of hosted FileMaker databases.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="listdatabases.php?ds=FMPro7" output="output_listdatabases">Run Example 1</button> Return a list of databases (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="listdatabases" output="output_listdatabases">Run Example 2</button> Return a list of databases (fmPDA for FX.php)
               </div>
               <div id="output_listdatabases" class="api-example-output"></div>
            </div>

            <div id="apiListLayouts" class="api-object">
               <div class="api-header">
                  FX::FMLayoutNames()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMLayoutNames()

                        Retrieve a list of layouts for a database.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="listlayouts.php?ds=FMPro7" output="output_listlayouts">Run Example 1</button> Return a list of layouts (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="listlayouts" output="output_listlayouts">Run Example 2</button> Return a list of layouts (fmPDA for FX.php)
               </div>
               <div id="output_listlayouts" class="api-example-output"></div>
            </div>

            <div id="apiListScripts" class="api-object">
               <div class="api-header">
                  FX::FMScriptNames()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMScriptNames()

                        Retrieve a list of scripts for a database.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="listscripts.php?ds=FMPro7" output="output_listscripts">Run Example 1</button> Return a list of scripts (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="listscripts" output="output_listscripts">Run Example 2</button> Return a list of scripts (fmPDA for FX.php)
               </div>
               <div id="output_listscripts" class="api-example-output"></div>
            </div>

            <div id="apiViewLayoutObjects" class="api-object">
               <div class="api-header">
                  FX::FMView()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMView()

                        Retrieve the meta data for a layout.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="viewlayoutobjects.php?ds=FMPro7" output="output_viewlayoutobjects">Run Example 1</button> Retrieve the meta data for a layout (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="viewlayoutobjects" output="output_viewlayoutobjects">Run Example 2</button> Retrieve the meta data for a layout (fmPDA for FX.php)
               </div>
               <div id="output_viewlayoutobjects" class="api-example-output"></div>
            </div>

            <div id="apiFindAll" class="api-object">
               <div class="api-header">
                  FX::FMFindAll()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMFindAll()

                        Retrieve all records.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="findall.php?ds=FMPro7" output="output_findall">Run Example 1</button> Retrieve all records (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="findall" output="output_findall">Run Example 2</button> Retrieve all records (fmPDA for FX.php)
               </div>
               <div id="output_findall" class="api-example-output"></div>
            </div>

            <div id="apiFindAny" class="api-object">
               <div class="api-header">
                  FX::FMFindAny()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMFindAny()

                        Retrieve a random record. For the Data API version, it always returns the first record.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="findany.php?ds=FMPro7" output="output_findany">Run Example 1</button> Retrieve any record (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="findany" output="output_findany">Run Example 2</button> Retrieve any record (fmPDA for FX.php)
               </div>
               <div id="output_findany" class="api-example-output"></div>
            </div>

            <div id="apiFindSimple" class="api-object">
               <div class="api-header">
                  FX::FMFind()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMFind()

                        Retrieve records.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="find.php?ds=FMPro7&ft=simple" output="output_findsimple">Run Example 1</button> Retrieve records with a simple (non compound) Find (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="find.php?ft=simple" output="output_findsimple">Run Example 2</button> Retrieve records with a simple (non compound) Find (fmPDA for FX.php)
               </div>
               <div id="output_findsimple" class="api-example-output"></div>
            </div>

            <div id="apiFindCompound" class="api-object">
               <div class="api-header">
                  FX::FMFind()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMFind()

                        Retrieve records.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="find.php?ds=FMPro7&ft=compound" output="output_findcompound">Run Example 1</button> Retrieve records with a Compound Find (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="find.php?ft=compound" output="output_findcompound">Run Example 2</button> Retrieve records with a Compound Find (fmPDA for FX.php)
               </div>
               <div id="output_findcompound" class="api-example-output"></div>
            </div>

            <div id="apiAddRecord" class="api-object">
               <div class="api-header">
                  FX::FMNew()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMNew()

                        Create a new record.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="new.php?ds=FMPro7" output="output_new">Run Example 1</button> Create a new record (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="new" output="output_new">Run Example 2</button> Create a new record (fmPDA for FX.php)
               </div>
               <div id="output_new" class="api-example-output"></div>
            </div>

            <div id="apiEditRecord" class="api-object">
               <div class="api-header">
                  FX::FMEdit()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMEdit()

                        Edit record.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="edit.php?ds=FMPro7" output="output_edit">Run Example 1</button> Edit a record (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="edit" output="output_edit">Run Example 2</button> Edit a record (fmPDA for FX.php)
               </div>
               <div id="output_edit" class="api-example-output"></div>
            </div>

            <div id="apiDeleteRecord" class="api-object">
               <div class="api-header">
                  FX::FMDelete()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMDelete()

                        Delete record.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="delete.php?ds=FMPro7" output="output_delete">Run Example 1</button> Delete a record (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="delete" output="output_delete">Run Example 2</button> Delete a record (fmPDA for FX.php)
               </div>
               <div id="output_delete" class="api-example-output"></div>
            </div>

            <div id="apiDuplicateRecord" class="api-object">
               <div class="api-header">
                  FX::FMDup()
               </div>

               <div class="api-description">
                  <pre><code class="language-php">
                     function FMDup()

                        Duplicate record.
                  </code></pre>
               </div>

               <div class="api-example-output-header">
                 <button type="button" class="btn btn-primary run_php_script" phpscript="duplicate.php?ds=FMPro7" output="output_duplicate">Run Example 1</button> Duplicate a record (Legacy FX.php)<br>
                 <br>
                 <button type="button" class="btn btn-primary run_php_script" phpscript="duplicate" output="output_duplicate">Run Example 2</button> Duplicate a record (fmPDA for FX.php)
               </div>
               <div id="output_duplicate" class="api-example-output"></div>
            </div>

            <br>
            <br>
            <br>


            Mark DeNyse<br>
            Driftwood Interactive<br>
            <a href="mailto:info@driftwoodinteractive.com">info@driftwoodinteractive.com</a><br>
            <br>

         </div>

      </div>


      <!-- Always at the end of the page -->
      <footer>
         <a href="http://www.driftwoodinteractive.com"><img src="img/di.png" height="32" width="128" alt="Driftwood Interactive" style="vertical-align:text-bottom"></a><br>
         Copyright &copy; <?php echo date('Y'); ?> Mark DeNyse Released Under the MIT License.
      </footer>


      <script>
         $(".run_php_script").click(function() {
            target = $(this).attr("target");
            theID = $(this).attr("phpscript");
            outputID = $(this).attr("output");
            if (outputID == null) {
               outputID = "output_" + theID;
            }

            theURL = theID;
            if (theID.indexOf(".php") == -1) {
               theURL += ".php";
            }

            if (target == "_blank") {
               window.open(theURL);
            }
            else {
               $.ajax({
                    url: theURL,
                    dataType: 'html',
                    timeout: 10000,
                    success: function(data, textStatus, jqXHR) {
                        if (data != null) {
                           $("#"+ outputID).append(data);
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        alert("error!");
                        $("#"+ outputID).append("Error!!! "+ textStatus +" "+ errorThrown);
                    }
               });
            }
         });
      </script>

   </body>
</html>
